;
; KRAFT80 Defines
;

isr1vector	.equ	0x4102	;STACKTOP+2
isr2vector	.equ	0x4104	;STACKTOP+4

PORTBUTTONS	.equ	0x00	
PORTDATA	.equ	0x50
PORTADDRL	.equ	0x51
PORTADDRH	.equ	0x52
PORTMODE	.equ	0x53

;   PS2 KEYBOARD
PORTKEY		.equ	0x55

;
; Game Defines
;

INVADER_COLS	.equ	11
INVADER_ROWS	.equ	5
INVADER_NUM	.equ	(INVADER_COLS*INVADER_ROWS)	
INVADERS_VSPACING .equ	8

PLAYFIELD_WIDTH	.equ	224

PLAY_WIDTH_BYTES .equ	(PLAYFIELD_WIDTH/2)
VSTEP		.equ	12
VSTEP2		.equ	INVADERS_VSPACING

BYTES_PER_LINE	.equ	160

LEFT_OFFSET_BYTES .equ	(BYTES_PER_LINE - PLAY_WIDTH_BYTES)/2


CANNON_VPOS	.equ	220
CANNON_SCR_OFS	.equ	(BYTES_PER_LINE*CANNON_VPOS+LEFT_OFFSET_BYTES)
BLINE_SCR_OFS	.equ	(BYTES_PER_LINE*(10+CANNON_VPOS)+LEFT_OFFSET_BYTES)

BUNKER1_SCR_OFS	.equ	(BYTES_PER_LINE*(CANNON_VPOS-24)+16+LEFT_OFFSET_BYTES)
BUNKER2_SCR_OFS	.equ	(BUNKER1_SCR_OFS+23)
BUNKER3_SCR_OFS	.equ	(BUNKER2_SCR_OFS+23)
BUNKER4_SCR_OFS	.equ	(BUNKER3_SCR_OFS+23)

INV_DIVIDER_INI	 .equ	550
INV_DIVIDER_DROP .equ	10

NUM_BOMBS	.equ	8

