;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;  INVADERS FOR KRAFT 80
;  A mini game inspired on Taito's Space Invaders
;  14-Oct-2025 - ARMCoder
;  Graphics module
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		.include "defines.h"

		.globl	set_screen
		.globl	drawbaseline, clear_lines, clrscr
		.globl	print_cannon, print_invaders, print_sprite, print_bunkers
		.globl	scrpos_invaders, stepping
		.globl	print_cannon_die

		.module graphics

		.area	CODE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

set_screen:
		ld	a,#1
		out	(PORTMODE),a
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

drawbaseline:
		ld	hl,#BLINE_SCR_OFS
		ld	a,l
		out	(PORTADDRL),a
		ld	a,h
		out	(PORTADDRH),a
		ld	b,#PLAY_WIDTH_BYTES
		ld	a,#0xcc		;lightred
bline:		out	(PORTDATA),a
		djnz	bline
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

clear_lines:	ld	hl,(scrpos_invaders)

		ld	a,(row_end)
		inc	a
		ld	b,a
		ld	c,#VSTEP
cleanln00:	push	hl
		push	bc

		ld	b,c
		ld	de,#BYTES_PER_LINE

clearln0:	push	bc
		xor	a
		sbc	hl,de

		;;;;;;;;;;;;;;;;;;;;; 1 pixel line

		ld	a,l
		out	(PORTADDRL),a
		ld	a,h
		out	(PORTADDRH),a

		ld	a,(col_start)
		ld	b,a
		ld	a,(col_end)
		sub	b
		inc	a
		add	a,a
		add	a,a
		add	a,a
		ld	b,a
		
		xor	a	;ld	a,#0x44
clearln1:	out	(PORTDATA),a
		djnz	clearln1
		pop	bc
		
		djnz	clearln0

		pop	bc
		pop	hl
		ld	de,#BYTES_PER_LINE*(8+INVADERS_VSPACING)
		add	hl,de
		ld	c,#VSTEP2
		djnz	cleanln00
		ret
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

clrscr:		xor	a
		out	(PORTADDRL),a
		out	(PORTADDRH),a
		ld	c,#240
clrscr1:	ld	b,#BYTES_PER_LINE
clrscr2:	out	(PORTDATA),a
		djnz	clrscr2
		dec	c
		jr	nz,clrscr1
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

print_cannon:
		ld	bc,#cannon1
		ld	a,(cannon_hpos_px)
		bit	0,a
		jr	z,baseis1
		ld	bc,#cannon2

baseis1:	ld	hl,#CANNON_SCR_OFS
		srl	a
		ld	e,a
		ld	d,#0
		add	hl,de		; hl = screen mem pos
		jp	print_sprite

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

print_cannon_die:
		ld	bc,#cannondie1
		ld	hl,(cannondie_state)
		bit	4,l
		jr	z,baseisdie1
		ld	bc,#cannondie2

baseisdie1:	ld	hl,#CANNON_SCR_OFS
		ld	a,(cannon_hpos_px)
		srl	a
		ld	e,a
		ld	d,#0
		add	hl,de		; hl = screen mem pos
		jp	print_sprite

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

print_invaders:	ld	hl,(scrpos_invaders)
		ld	(spritepos),hl

		ld	hl,#invader_matrix
		ld	a,(col_start)
		ld	e,a
		ld	d,#0
		add	hl,de
		ld	(invader_matnow),hl
		ld	(invader_matnow2),hl
		
		xor	a		; Row

print_inv1:	ld	(row_now),a

		ld	hl,(spritepos)
		ld	(spritenow),hl
		
		ld	a,(col_start)
		;ld	b,a
		;ld	c,#0
		;add	hl,bc

print_inv1a:	ld	(col_now),a	; Invader row
		;ld	a,(hl)
		
		ld	hl,(invader_matnow2)
		ld	a,(hl)
		inc	hl
		ld	(invader_matnow2),hl
		or	a
		jr	z,blk		; No invader here, blank
		
		ld	a,(row_now)	; Invader type here
		add	a,a
		ld	b,a
		ld	a,(stepping)
		add	a,b
		or	a
		jr	z,sq1a
		dec	a
		jr	z,sq1b
		dec	a
		jr	z,cr1a
		dec	a
		jr	z,cr1b
		dec	a
		jr	z,cr2a
		dec	a
		jr	z,cr2b
		dec	a
		jr	z,oc1a
		dec	a
		jr	z,oc1b
		dec	a
		jr	z,oc2a
		dec	a
		jr	z,oc2b
		
blk:		ld	bc,#blank		
		jr	sprok
sq1a:		ld	bc,#squid1a
		jr	sprok
sq1b:		ld	bc,#squid1b
		jr	sprok
cr1a:		ld	bc,#crab1a
		jr	sprok
cr1b:		ld	bc,#crab1b
		jr	sprok
cr2a:		ld	bc,#crab2a
		jr	sprok
cr2b:		ld	bc,#crab2b
		jr	sprok
oc1a:		ld	bc,#octo1a
		jr	sprok
		
sprok:		ld	hl,(spritenow)
		push	hl
		call	print_sprite
		pop	hl
		ld	de,#8
		add	hl,de
		ld	(spritenow),hl
		
		ld	a,(col_now)
		ld	b,a
		ld	a,(col_end)
		cp	b
		jr	z,print_inv2

		inc	b
		ld	a,b
		jr	print_inv1a	; End invader row

oc1b:		ld	bc,#octo1b
		jr	sprok
oc2a:		ld	bc,#octo2a
		jr	sprok
oc2b:		ld	bc,#octo2b
		jr	sprok
		
print_inv2:	ld	hl,(spritepos)
		ld	de,#BYTES_PER_LINE*(8+INVADERS_VSPACING)
		add	hl,de
		ld	(spritepos),hl

		ld	hl,(invader_matnow)
		ld	de,#INVADER_COLS
		add	hl,de
		ld	(invader_matnow),hl
		ld	(invader_matnow2),hl

		ld	a,(row_now)
		ld	b,a
		ld	a,(row_end)
		cp	b
		ret	z
		inc	b
		ld	a,b

	;	push	af
	;	call	move_cannon
	;	pop	af

		jp	print_inv1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

print_sprite:	ld	d,b		; bc = sprite  hl = scrpos
		ld	e,c
		ld	c,#8
printlb1:	ld	a,l
		out	(PORTADDRL),a
		ld	a,h
		out	(PORTADDRH),a

		ld	b,#8
printlb2:	ld	a,(de)
		out	(PORTDATA),a
		inc	de
		djnz	printlb2		

		ld	a,l
		add	a,#BYTES_PER_LINE
		ld	l,a
		jr	nc,printlb3
		inc	h

printlb3:	dec	c
		jr	nz,printlb1

		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		
;;
;; CGA Colors
;; 0 BLACK      8 DARKGRAY
;; 1 BLUE       9 LIGHTBLUE
;; 2 GREEN     10 LIGHTGREEN
;; 3 CYAN      11 LIGHTCYAN
;; 4 RED       12 LIGHTRED
;; 5 MAGENTA   13 LIGHTMAGENTA
;; 6 BROWN     14 YELLOW
;; 7 GRAY      15 WHITE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

print_bunkers:	ld	hl,#BUNKER1_SCR_OFS
		call	print_bunker
		ld	hl,#BUNKER2_SCR_OFS
		call	print_bunker
		ld	hl,#BUNKER3_SCR_OFS
		call	print_bunker
		ld	hl,#BUNKER4_SCR_OFS
		call	print_bunker
		ret
		
print_bunker:	; HL = screen position
		
		; Row 1
		ld	a,l
		out	(PORTADDRL),a
		ld	a,h
		out	(PORTADDRH),a
		xor	a
		out	(PORTDATA),a
		out	(PORTDATA),a
		ld	b,#7
		call	print_bunkline

		ld	de,#BYTES_PER_LINE

		; Row 2
		add	hl,de
		ld	a,l
		out	(PORTADDRL),a
		ld	a,h
		out	(PORTADDRH),a
		xor	a
		out	(PORTDATA),a
		ld	a,#0x0c
		out	(PORTDATA),a
		ld	b,#7
		call	print_bunkline
		ld	a,#0xc0
		out	(PORTDATA),a

		; Row 3
		add	hl,de
		ld	a,l
		out	(PORTADDRL),a
		ld	a,h
		out	(PORTADDRH),a
		xor	a
		out	(PORTDATA),a
		ld	b,#9
		call	print_bunkline

		; Row 4
		add	hl,de
		ld	a,l
		out	(PORTADDRL),a
		ld	a,h
		out	(PORTADDRH),a
		ld	a,#0x0c
		out	(PORTDATA),a
		ld	b,#9
		call	print_bunkline
		ld	a,#0xc0
		out	(PORTDATA),a

		; Rows 5-12
		ld	b,#8
pbunk5:		push	bc
		add	hl,de
		ld	a,l
		out	(PORTADDRL),a
		ld	a,h
		out	(PORTADDRH),a
		ld	b,#11
		call	print_bunkline
		pop	bc
		djnz	pbunk5

		; Row 13
		add	hl,de
		ld	a,l
		out	(PORTADDRL),a
		ld	a,h
		out	(PORTADDRH),a
		ld	b,#4
		call	print_bunkline
		xor	a
		out	(PORTDATA),a
		out	(PORTDATA),a
		out	(PORTDATA),a
		ld	b,#4
		call	print_bunkline

		; Row 14
		add	hl,de
		ld	a,l
		out	(PORTADDRL),a
		ld	a,h
		out	(PORTADDRH),a
		ld	b,#3
		call	print_bunkline
		ld	a,#0xc0
		out	(PORTDATA),a
		xor	a
		out	(PORTDATA),a
		out	(PORTDATA),a
		out	(PORTDATA),a
		ld	a,#0x0c
		out	(PORTDATA),a
		ld	b,#3
		call	print_bunkline

		; Rows 15-16
		ld	b,#2
pbunk15:	push	bc
		add	hl,de
		ld	a,l
		out	(PORTADDRL),a
		ld	a,h
		out	(PORTADDRH),a
		ld	b,#3
		call	print_bunkline
		xor	a
		out	(PORTDATA),a
		out	(PORTDATA),a
		out	(PORTDATA),a
		out	(PORTDATA),a
		out	(PORTDATA),a
		ld	b,#3
		call	print_bunkline
		pop	bc
		djnz	pbunk15
		
		ret

print_bunkline:	ld	a,#0xcc

pbunkl:		out	(PORTDATA),a
		djnz	pbunkl
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; BLANK (NO COLOR) ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ........ ........
;; ........ ........
;; ........ ........
;; ........ ........
;; ........ ........
;; ........ ........
;; ........ ........
;; ........ ........
blank:		.byte	0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00
		.byte	0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00
		.byte	0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00
		.byte	0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00
		.byte	0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00
		.byte	0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00
		.byte	0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00
		.byte	0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00
				
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; SQUID1 (LIGHTGREEN) ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; .......# #.......
;; ......## ##......
;; .....### ###.....
;; ....##.# #.##....
;; ....#### ####....
;; ......#. .#......
;; .....#.# #.#.....
;; ....#.#. .#.#....
squid1a:	.byte	0x00,0x00,0x00,0x0a, 0xa0,0x00,0x00,0x00
		.byte	0x00,0x00,0x00,0xaa, 0xaa,0x00,0x00,0x00
		.byte	0x00,0x00,0x0a,0xaa, 0xaa,0xa0,0x00,0x00
		.byte	0x00,0x00,0xaa,0x0a, 0xa0,0xaa,0x00,0x00
		.byte	0x00,0x00,0xaa,0xaa, 0xaa,0xaa,0x00,0x00
		.byte	0x00,0x00,0x00,0xa0, 0x0a,0x00,0x00,0x00
		.byte	0x00,0x00,0x0a,0x0a, 0xa0,0xa0,0x00,0x00
		.byte	0x00,0x00,0xa0,0xa0, 0x0a,0x0a,0x00,0x00

;; .......# #.......
;; ......## ##......
;; .....### ###.....
;; ....##.# #.##....
;; ....#### ####....
;; .....#.# #.#.....
;; ....#... ...#....
;; .....#.. ..#.....
squid1b:	.byte	0x00,0x00,0x00,0x0a, 0xa0,0x00,0x00,0x00
		.byte	0x00,0x00,0x00,0xaa, 0xaa,0x00,0x00,0x00
		.byte	0x00,0x00,0x0a,0xaa, 0xaa,0xa0,0x00,0x00
		.byte	0x00,0x00,0xaa,0x0a, 0xa0,0xaa,0x00,0x00
		.byte	0x00,0x00,0xaa,0xaa, 0xaa,0xaa,0x00,0x00
		.byte	0x00,0x00,0x0a,0x0a, 0xa0,0xa0,0x00,0x00
		.byte	0x00,0x00,0xa0,0x00, 0x00,0x0a,0x00,0x00
		.byte	0x00,0x00,0x0a,0x00, 0x00,0xa0,0x00,0x00

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; CRAB1 (LIGHTGREEN) ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ....#... ..#.....
;; ..#..#.. .#..#...
;; ..#.#### ###.#...
;; ..###.## #.###...
;; ..###### #####...
;; ...##### ####....
;; ....#... ..#.....
;; ...#.... ...#....
crab1a:		.byte	0x00,0x00,0xa0,0x00, 0x00,0xa0,0x00,0x00
		.byte	0x00,0xa0,0x0a,0x00, 0x0a,0x00,0xa0,0x00
		.byte	0x00,0xa0,0xaa,0xaa, 0xaa,0xa0,0xa0,0x00
		.byte	0x00,0xaa,0xa0,0xaa, 0xa0,0xaa,0xa0,0x00
		.byte	0x00,0xaa,0xaa,0xaa, 0xaa,0xaa,0xa0,0x00
		.byte	0x00,0x0a,0xaa,0xaa, 0xaa,0xaa,0x00,0x00
		.byte	0x00,0x00,0xa0,0x00, 0x00,0xa0,0x00,0x00
		.byte	0x00,0x0a,0x00,0x00, 0x00,0x0a,0x00,0x00
		
;; ....#... ..#.....
;; .....#.. .#......
;; ....#### ### ....
;; ...##.## #.##....
;; ..###### #####...
;; ..#.#### ###.#...
;; ..#.#... ..#.#...
;; .....##. ##......
crab1b:		.byte	0x00,0x00,0xa0,0x00, 0x00,0xa0,0x00,0x00
		.byte	0x00,0x00,0x0a,0x00, 0x0a,0x00,0x00,0x00
		.byte	0x00,0x00,0xaa,0xaa, 0xaa,0xa0,0x00,0x00
		.byte	0x00,0x0a,0xa0,0xaa, 0xa0,0xaa,0x00,0x00
		.byte	0x00,0xaa,0xaa,0xaa, 0xaa,0xaa,0xa0,0x00
		.byte	0x00,0xa0,0xaa,0xaa, 0xaa,0xa0,0xa0,0x00
		.byte	0x00,0xa0,0xa0,0x00, 0x00,0xa0,0xa0,0x00
		.byte	0x00,0x00,0x0a,0xa0, 0xaa,0x00,0x00,0x00	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; CRAB2 (LIGHTCYAN) ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ....#... ..#.....
;; ..#..#.. .#..#...
;; ..#.#### ###.#...
;; ..###.## #.###...
;; ..###### #####...
;; ...##### ####....
;; ....#... ..#.....
;; ...#.... ...#....
crab2a:		.byte	0x00,0x00,0xb0,0x00, 0x00,0xb0,0x00,0x00
		.byte	0x00,0xb0,0x0b,0x00, 0x0b,0x00,0xb0,0x00
		.byte	0x00,0xb0,0xbb,0xbb, 0xbb,0xb0,0xb0,0x00
		.byte	0x00,0xbb,0xb0,0xbb, 0xb0,0xbb,0xb0,0x00
		.byte	0x00,0xbb,0xbb,0xbb, 0xbb,0xbb,0xb0,0x00
		.byte	0x00,0x0b,0xbb,0xbb, 0xbb,0xbb,0x00,0x00
		.byte	0x00,0x00,0xb0,0x00, 0x00,0xb0,0x00,0x00
		.byte	0x00,0x0b,0x00,0x00, 0x00,0x0b,0x00,0x00
		
;; ....#... ..#.....
;; .....#.. .#......
;; ....#### ### ....
;; ...##.## #.##....
;; ..###### #####...
;; ..#.#### ###.#...
;; ..#.#... ..#.#...
;; .....##. ##......
crab2b:		.byte	0x00,0x00,0xb0,0x00, 0x00,0xb0,0x00,0x00
		.byte	0x00,0x00,0x0b,0x00, 0x0b,0x00,0x00,0x00
		.byte	0x00,0x00,0xbb,0xbb, 0xbb,0xb0,0x00,0x00
		.byte	0x00,0x0b,0xb0,0xbb, 0xb0,0xbb,0x00,0x00
		.byte	0x00,0xbb,0xbb,0xbb, 0xbb,0xbb,0xb0,0x00
		.byte	0x00,0xb0,0xbb,0xbb, 0xbb,0xb0,0xb0,0x00
		.byte	0x00,0xb0,0xb0,0x00, 0x00,0xb0,0xb0,0x00
		.byte	0x00,0x00,0x0b,0xb0, 0xbb,0x00,0x00,0x00	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; OCTO1 (LIGHTCYAN) ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ......## ##......
;; ...##### #####...
;; ..###### ######..
;; ..###..# #..###..
;; ..###### ######..
;; .....##. .##.....
;; ....##.# #.##....
;; ..##.... ....##..
octo1a:		.byte	0x00,0x00,0x00,0xbb, 0xbb,0x00,0x00,0x00
		.byte	0x00,0x0b,0xbb,0xbb, 0xbb,0xbb,0xb0,0x00
		.byte	0x00,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0x00
		.byte	0x00,0xbb,0xb0,0x0b, 0xb0,0x0b,0xbb,0x00
		.byte	0x00,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0x00
		.byte	0x00,0x00,0x0b,0xb0, 0x0b,0xb0,0x00,0x00
		.byte	0x00,0x00,0xbb,0x0b, 0xb0,0xbb,0x00,0x00
		.byte	0x00,0xbb,0x00,0x00, 0x00,0x00,0xbb,0x00

;; ......## ##......
;; ...##### #####...
;; ..###### ######..
;; ..###..# #..###..
;; ..###### ######..
;; ....###. .###....
;; ...##..# #..##...
;; ....##.. ..##....
octo1b:		.byte	0x00,0x00,0x00,0xbb, 0xbb,0x00,0x00,0x00
		.byte	0x00,0x0b,0xbb,0xbb, 0xbb,0xbb,0xb0,0x00
		.byte	0x00,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0x00
		.byte	0x00,0xbb,0xb0,0x0b, 0xb0,0x0b,0xbb,0x00
		.byte	0x00,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0x00
		.byte	0x00,0x00,0xbb,0xb0, 0x0b,0xbb,0x00,0x00
		.byte	0x00,0x0b,0xb0,0x0b, 0xb0,0x0b,0xb0,0x00
		.byte	0x00,0x00,0xbb,0x00, 0x00,0xbb,0x00,0x00

;;;;;;;;;;;;;;;;;;;;;;;;;;;; OCTO2 (LIGHTMAGENTA) ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ......## ##......
;; ...##### #####...
;; ..###### ######..
;; ..###..# #..###..
;; ..###### ######..
;; .....##. .##.....
;; ....##.# #.##....
;; ..##.... ....##..
octo2a:		.byte	0x00,0x00,0x00,0xdd, 0xdd,0x00,0x00,0x00
		.byte	0x00,0x0d,0xdd,0xdd, 0xdd,0xdd,0xd0,0x00
		.byte	0x00,0xdd,0xdd,0xdd, 0xdd,0xdd,0xdd,0x00
		.byte	0x00,0xdd,0xd0,0x0d, 0xd0,0x0d,0xdd,0x00
		.byte	0x00,0xdd,0xdd,0xdd, 0xdd,0xdd,0xdd,0x00
		.byte	0x00,0x00,0x0d,0xd0, 0x0d,0xd0,0x00,0x00
		.byte	0x00,0x00,0xdd,0x0d, 0xd0,0xdd,0x00,0x00
		.byte	0x00,0xdd,0x00,0x00, 0x00,0x00,0xdd,0x00

;; ......## ##......
;; ...##### #####...
;; ..###### ######..
;; ..###..# #..###..
;; ..###### ######..
;; ....###. .###....
;; ...##..# #..##...
;; ....##.. ..##....
octo2b:		.byte	0x00,0x00,0x00,0xdd, 0xdd,0x00,0x00,0x00
		.byte	0x00,0x0d,0xdd,0xdd, 0xdd,0xdd,0xd0,0x00
		.byte	0x00,0xdd,0xdd,0xdd, 0xdd,0xdd,0xdd,0x00
		.byte	0x00,0xdd,0xd0,0x0d, 0xd0,0x0d,0xdd,0x00
		.byte	0x00,0xdd,0xdd,0xdd, 0xdd,0xdd,0xdd,0x00
		.byte	0x00,0x00,0xdd,0xd0, 0x0d,0xdd,0x00,0x00
		.byte	0x00,0x0d,0xd0,0x0d, 0xd0,0x0d,0xd0,0x00
		.byte	0x00,0x00,0xdd,0x00, 0x00,0xdd,0x00,0x00

;;;;;;;;;;;;;;;;;;;;;;;;;;; LASER BASE (LIGHTCYAN) ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; .......# ........
;; ......## #.......
;; ......## #.......
;; ..###### #####...
;; .####### ######..
;; .####### ######..
;; .####### ######..
;; .####### ######..
cannon1:	.byte	0x00,0x00,0x00,0x0b, 0x00,0x00,0x00,0x00
  		.byte	0x00,0x00,0x00,0xbb, 0xb0,0x00,0x00,0x00
  		.byte	0x00,0x00,0x00,0xbb, 0xb0,0x00,0x00,0x00
  		.byte	0x00,0xbb,0xbb,0xbb, 0xbb,0xbb,0xb0,0x00
  		.byte	0x0b,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0x00
  		.byte	0x0b,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0x00
  		.byte	0x0b,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0x00
  		.byte	0x0b,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0x00

;; ........ #.......
;; .......# ##......
;; .......# ##......
;; ...##### ######..
;; ..###### #######.
;; ..###### #######.
;; ..###### #######.
;; ..###### #######.
cannon2:	.byte	0x00,0x00,0x00,0x00, 0xb0,0x00,0x00,0x00
  		.byte	0x00,0x00,0x00,0x0b, 0xbb,0x00,0x00,0x00
  		.byte	0x00,0x00,0x00,0x0b, 0xbb,0x00,0x00,0x00
  		.byte	0x00,0x0b,0xbb,0xbb, 0xbb,0xbb,0xbb,0x00
  		.byte	0x00,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0xb0
  		.byte	0x00,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0xb0
  		.byte	0x00,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0xb0
  		.byte	0x00,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0xb0

;; ........ ........
;; ...#..## ...#....
;; ........ #.#.....
;; ..#.#.## ####.#..
;; .##.###. .####...
;; .#.##### ###.###.
;; ..###.## ######..
;; .####### ######..
cannondie1:	.byte	0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00
		.byte	0x00,0x0b,0x00,0xbb, 0x00,0x0b,0x00,0x00
		.byte	0x00,0x00,0x00,0x00, 0xb0,0xb0,0x00,0x00
		.byte	0x00,0xb0,0xb0,0xbb, 0xbb,0xbb,0x0b,0x00
		.byte	0x0b,0xb0,0xbb,0xb0, 0x0b,0xbb,0xb0,0x00
		.byte	0x0b,0x0b,0xbb,0xbb, 0xbb,0xb0,0xbb,0xb0
		.byte	0x00,0xbb,0xb0,0xbb, 0xbb,0xbb,0xbb,0x00
		.byte	0x0b,0xbb,0xbb,0xbb, 0xbb,0xbb,0xbb,0x00

;; ........ ........
;; .#.#..#. .###....
;; ....#... #.#.....
;; .##.#.## ####.#..
;; ..###.## .####...
;; .#.##### ###.##..
;; ..##..## .######.
;; .#.##### .#####..
cannondie2:	.byte	0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00
		.byte	0x0b,0x0b,0x00,0xb0, 0x0b,0xbb,0x00,0x00
		.byte	0x00,0x00,0xb0,0x00, 0xb0,0xb0,0x00,0x00
		.byte	0x0b,0xb0,0xb0,0xbb, 0xbb,0xbb,0x0b,0x00
		.byte	0x00,0xbb,0xb0,0xbb, 0x0b,0xbb,0xb0,0x00
		.byte	0x0b,0x0b,0xbb,0xbb, 0xbb,0xb0,0xbb,0x00
		.byte	0x00,0xbb,0x00,0xbb, 0x0b,0xbb,0xbb,0xb0
		.byte	0x0b,0x0b,0xbb,0xbb, 0x0b,0xbb,0xbb,0x00

	.area	DATA

spritepos:	.ds	2
spritenow:	.ds	2
col_now:	.ds	1
scrpos_invaders:.ds	2
row_now:	.ds	1
invader_matnow:	.ds	2
invader_matnow2:.ds	2
stepping:	.ds	1


